function [u,tab]=df_srelax(h,epsilon,maxiter,step,show,verbose)
%sobrerelajacin sucesiva

delta = step/4.0;

CB1 = -4;
CB2 = 8;

%Calculando cantidad de puntos

na = 1.5/h;
nb = 2.5/h;
nc = 0.5/h;
nd = 2/h;
ne = 3/h;

%Contruyendo tabla de conversion  i,j <-> k

%nmero de incognitas
N = (nb+1)*(nc+1)+(nd-nc-1)*(na+1)+(nb+1)*(ne-nd+1);
%tabla de conversin
tab = zeros(N,2);
k = 1;

%Aqu se guardar la solucin
u = zeros(nb+1,ne+1)*NaN;

%Se construye tabla de conversin y se entrega condicion inicial nula.

%A
for j=1:nc+1
    for i=1:nb+1
        tab(k,1)=i;
        tab(k,2)=j;
        k=k+1;
        
        u(i,j) = 0;
    end
end

%B
for j=nc+2:nd
    for i=1:na+1
        tab(k,1)=i;
        tab(k,2)=j;
        k=k+1;

        u(i,j) = 0;
    end
end

%C
for j=nd+1:ne+1
    for i=1:nb+1
        tab(k,1)=i;
        tab(k,2)=j;
        k=k+1;

        u(i,j) = 0;
    end
end

if (show)
    surf(u);
    drawnow,pause(0.1);
end

%nmero de iteracion actual
it = 0;

%Iteramos hasta maxiter veces.
while it < maxiter
    
    %acumulador para medir el error
    err = 0;

    %Se recorre todo el dominio
    for k=1:N
        [i,j]=getIJ(k,tab);

        if i-1==0 && j-1==0           %a            
            new = u(i,j) + (2*u(i+1,j) + 2*u(i,j+1) - 4*u(i,j))*delta;
            
        elseif i-1==0 && j+1==ne+2    %h
            new = u(i,j) + (2*u(i+1,j) + 2*u(i,j-1) - 4*u(i,j))*delta;
            
        elseif i-1==0                %1
            new = u(i,j) + (2*u(i+1,j) + u(i,j-1) + u(i,j+1) - 4*u(i,j))*delta;
            
        elseif j-1==0 && i+1==nb+2    %b
            new = u(i,j) + (2*u(i-1,j) + 2*u(i,j+1) - 4*u(i,j) + 2*CB2*h)*delta;
            
        elseif j-1==0                %2
            new = u(i,j) + (u(i-1,j) + u(i+1,j) + 2*u(i,j+1) - 4*u(i,j))*delta;
            
        elseif i+1==nb+2 && j+1==nc+2 %c
            new = u(i,j) + (2*u(i-1,j) + 2*u(i,j-1) - 4*u(i,j) + 2*CB2*h)*delta;
            
        elseif i+1==nb+2 && j<nc+1   %3
            new = u(i,j) + (2*u(i-1,j) + u(i,j+1) + u(i,j-1) - 4*u(i,j) + 2*CB2*h)*delta;
            
        elseif j+1==nc+2 && i>na+1   %4
            new = u(i,j) + (u(i-1,j) + u(i+1,j) + 2*u(i,j-1) - 4*u(i,j))*delta;
            
        elseif i+1==na+2 && j>nc+1 && j<nd+1    %5
            new = u(i,j) + (2*u(i-1,j) + u(i,j+1) + u(i,j-1) - 4*u(i,j))*delta;
            
        elseif j-1==nd && i+1==nb+2   %f
            new = u(i,j) + (2*u(i-1,j) + 2*u(i,j+1) - 4*u(i,j) + 2*CB1*h)*delta;
            
        elseif j-1==nd && i>na+1      %6
            new = u(i,j) + (u(i-1,j) + u(i+1,j) + 2*u(i,j+1) - 4*u(i,j))*delta;
            
        elseif i+1==nb+2 && j+1==ne+2   %g
            new = u(i,j) + (2*u(i-1,j) + 2*u(i,j-1) - 4*u(i,j) + 2*CB1*h)*delta;
           
        elseif i+1==nb+2                %7
            new = u(i,j) + (2*u(i-1,j) + u(i,j+1) + u(i,j-1) - 4*u(i,j) + 2*CB1*h)*delta;
            
        elseif j+1==ne+2                %8
            new = u(i,j) + (u(i-1,j) + u(i+1,j) + 2*u(i,j-1) - 4*u(i,j))*delta;
            
        else                            %punto interior
            new = u(i,j) + (u(i-1,j) + u(i+1,j) + u(i,j-1) + u(i,j+1) - 4*u(i,j))*delta;
            
        end
        
        err = err + abs(u(i,j) - new);
        u(i,j) = new;
    end
    
    err = sqrt(err)/N;
    
    if (verbose)
        text = sprintf('it = %d\terr = %f',it,err);
        disp(text);
    end
    
    if err < epsilon
        disp('Precisin alcanzada')
        break
    end
    
    if (show)
        surf(u);
        drawnow,pause(0.01);
    end
    
    it = it + 1;
end

if it == maxiter
    disp('Se alcanz el nmero mximo de iteraciones');
end

u=u';
